#include "libopgp.h"

int PGP_gtblk(u8_t * buf, u32_t get, u32_t * len, u32_t * eneof, FILE * inf)
{
  u32_t neof = *eneof, ll = *len;

  while (get) {
    if (get < ll) {
      ll -= get;
      if (get != fread(buf, 1, get, inf))
        exit(-2);
      break;
    }
    get -= ll;
    if (ll != fread(buf, 1, ll, inf))
      exit(-2);
    buf += ll;
    ll = 0;
    if (!neof)
      return -1;
    ll = PGP_nxpkt(&neof, inf);
  }
  *len = ll;
  *eneof = neof;
  return 0;
}
