/* OpenPGP for Palm III */
#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <System/SysEvtMgr.h>

#include "opgptst.h"

void RunOpenPGP(void);
void makepkr(void);
FormPtr form;

extern int syma, diga, zipa;

static void setadv()
{
  FormPtr renf;

  if (!(renf = FrmInitForm(fadvset)))
    return;

  CtlSetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, b3des)), 1);
  CtlSetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bsha)), 1);
  CtlSetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bzip)), 1);
  FrmDoDialog(renf);

  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bidea))))
    syma = 1;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, b3des))))
    syma = 2;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bcast))))
    syma = 3;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bbf))))
    syma = 4;

  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bmd5))))
    diga = 1;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bsha))))
    diga = 2;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, brmd))))
    diga = 3;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bbf))))
    diga = 5;

  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bzip))))
    zipa = 1;
  if (CtlGetValue(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, bgzip))))
    zipa = 2;

  FrmDeleteForm(renf);
}

static Boolean opgptst(EventPtr event)
{
  int handled = 0;

  switch (event->eType) {
  case frmOpenEvent:
    form = FrmGetActiveForm();
    FrmDrawForm(form);

    /* should be based on clipboard content */

    CtlSetValue(FrmGetObjectPtr(form, FrmGetObjectIndex(form, bdec)), 1);
    handled = 1;
    break;

  case ctlSelectEvent:
    switch (event->data.ctlEnter.controlID) {
    case brun:
      RunOpenPGP();
      handled = 1;
      break;
    }
    break;

  case menuEvent:
    switch (event->data.menu.itemID) {
    case mabout:
      FrmAlert(aabout);
      break;
    case madv:
      setadv();
      break;
    case mring:
      makepkr();
      break;
    }
    handled = 1;
  default:
    break;

  }
  return handled;
}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
  short err;
  int formID;
  FormPtr form;
  EventType event;

  if (cmd == sysAppLaunchCmdNormalLaunch) {
    FrmGotoForm(fmain);

    do {
      EvtGetEvent(&event, 500);

      if (SysHandleEvent(&event))
        continue;
      if (MenuHandleEvent((void *) 0, &event, &err))
        continue;
      if (event.eType == nilEvent)
        continue;

      if (event.eType == frmLoadEvent) {
        formID = event.data.frmLoad.formID;
        form = FrmInitForm(formID);
        FrmSetActiveForm(form);
        switch (formID) {
        case fmain:
          FrmSetEventHandler(form, (FormEventHandlerPtr) opgptst);
          break;
        }
      }
      FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);

  }
  return 0;
}
